from dbAPI import dbAPI
from auxiliary import AuxiliaryStruct
from customTypes import *

from typing import Dict, List
import csv
from log import logger


logs = logger()
logs.startCall()    



def exportMatriceCsv(soluzione:str, exportFileName:str) -> bool:
    '''Export a CSV di una soluzione (o parte di essa) salvata a db'''
    db:dbAPI = dbAPI()
    listPianiAlloc:List[str] = list(db.get_pianiAllocazione())
    
    find = lambda listPianiAlloc: next((pianoAlloc for pianoAlloc in listPianiAlloc if pianoAlloc[0] == soluzione), None)
    if find(listPianiAlloc) == None:
        print("error: soluzione non presente nel db")
        return False
    listSlotToExport = db.get_slotFromPianoAllocazione(soluzione)
    mapSettimana:Dict[str,List[str]] = dict()
    mapDocenti:Dict[str,str] = dict()
    mapTitolo:Dict[str,str] = dict()
    
    for item in listSlotToExport:
        ID_INC = item[5]
        if ID_INC not in mapSettimana.keys():
            mapSettimana[ID_INC] = ['']*35
            mapDocenti[ID_INC] = item[7]
            mapTitolo[ID_INC] = item[6]
                   
        [day,hour] = getDayFasciaOrariaFromString(item[8], item[9])
        dayInt:int = getIntFromDay(day)
        hourInt:int = getIntFromFasciaOraria(hour)
        if getTipoLocaleFromString(item[10]) in [TipoLocale.Aula, TipoLocale.Aula_CA, TipoLocale.Aula_CA2, TipoLocale.Aula_TB, TipoLocale.Aula_WB, TipoLocale.AulaAttrezzata, TipoLocale.AulaMultimediale]:
            for i in range(int(item[4])):
                mapSettimana[ID_INC][dayInt*7+hourInt+i] = 'X'
        else:
            for i in range(int(item[4])):
                mapSettimana[ID_INC][dayInt*7+hourInt+i] = item[10]
    
    file = open(exportFileName, "w")           
    for ID_INC in mapSettimana.keys():
        alfabetiche:List[str] = db.get_Alfabetiche_ofInsegnamento(int(ID_INC))
        nAlf = ''
        for alf in alfabetiche:
            if alf[0] != '0':
                nAlf = ' alf:' + alf[0]
        out:str = mapDocenti[ID_INC] + ";" + mapTitolo[ID_INC] + nAlf + ";" + str(ID_INC) +";"
        out += ";".join(mapSettimana[ID_INC]) 
        out += "\n"
        file.write(out)
    file.close()
    
                

def exportCSV(soluzione:str, exportFileName:str, day:Day = Day.Indifferente, fasciaOraria:FasciaOraria = FasciaOraria._Indifferente) -> bool:
    '''Export a CSV di una soluzione (o parte di essa) salvata a db'''
    db:dbAPI = dbAPI()
    listPianiAlloc:List[str] = list(db.get_pianiAllocazione())
    
    find = lambda listPianiAlloc: next((pianoAlloc for pianoAlloc in listPianiAlloc if pianoAlloc[0] == soluzione), None)
    if find(listPianiAlloc) == None:
        print("error: soluzione non presente nel db")
        return False
    
    listSlotToExport = list()
    if day == Day.Indifferente and fasciaOraria == FasciaOraria._Indifferente:
        listSlotToExport = db.get_slotFromPianoAllocazione(soluzione)
    elif day == Day.Indifferente and fasciaOraria != FasciaOraria._Indifferente:
        fasciaOrariaStr:str = getStringsFromDayHour(0,getIntFromFasciaOraria(fasciaOraria))[1]
        listSlotToExport = db.get_slotInFasciaOrariaFromPianoAllocazione(soluzione, fasciaOrariaStr)
    elif day != Day.Indifferente and fasciaOraria == FasciaOraria._Indifferente:
        dayStr:str = getStringsFromDayHour(getIntFromDay(day),0)[0]
        listSlotToExport = db.get_slotInDayFromPianoAllocazione(soluzione, dayStr)       
    else:
        dayStr, fasciaOrariaStr = getStringsFromDayHour(getIntFromDay(day), getIntFromFasciaOraria(fasciaOraria))
        listSlotToExport = db.get_slotInDayFasciaOrariaFromPianoAllocazione(soluzione, dayStr, fasciaOrariaStr)
        
    headerCsv = ["PianoAllocazione", "idSlot", "nStudentiAssegnati", "tipoLez", "numSlotConsecutivi", "ID_INC", "Insegnamento",
                 "Titolare", "Giorno", "Ora", "tipoLocale", "tipoErogazione", "capienzaAula", "squadra", "preseElettriche", "Note", "Docenti", "Orientamenti"]
    
    # prepare stuff for sorting
    unsortedIdList:List[Tuple[str,str]] = list()
    for row in listSlotToExport:
        getSortableStr = lambda day,fasciaOraria : str(getIdSlotFromString(day,fasciaOraria)[0]) + "_" + str(getIdSlotFromString(day,fasciaOraria)[1])
        unsortedIdList.append((row[1], getSortableStr(row[8],row[9])))
    sortedIdList:List[Tuple[str,str]] = list()
    sortedIdList = sorted(unsortedIdList, key=lambda tup: tup[1])
        
    with open(exportFileName, 'w', encoding='UTF8', newline='') as f:
        writer = csv.writer(f)
        writer.writerow(headerCsv)
        
        for sortedId in sortedIdList:
            for row in listSlotToExport:
                if sortedId[0] != row[1]:
                    continue
                
                listDocenti = db.get_DocentiFromSlotPianoAllocazione(soluzione, row[1])
                strDocenti:str = ''.join(map(lambda item: str(item[0]) + ", ", listDocenti))
                
                listOrientamenti = db.get_Orientamenti_ofInsegnamento(int(row[5]))
                strOrientamenti:str = ''.join(map(lambda item: str(item[1]) + " - " + str(item[2]) + " - Triennale, " if str(item[0]) == "1" else str(item[1]) + " - " + str(item[2]) + " - Magistrale, ", listOrientamenti))
                
                rowOk = list()
                for i in range(len(row)):
                    if i == 9:
                        rowOk.append(getSlotFromHour(getIdSlotFromString("Lun",row[9])[1], int(row[4])))
                    elif i == 6:
                        alfabetiche:List[str] = db.get_Alfabetiche_ofInsegnamento(int(row[5]))
                        nAlf = ''
                        for alf in alfabetiche:
                            if alf[0] != '0':
                                nAlf = ' alf:' + alf[0]
                        rowOk.append(str(row[i]) + nAlf)
                    else:
                        rowOk.append(row[i])
                rowOk.append(strDocenti[:-2])
                rowOk.append(strOrientamenti[:-2])
                writer.writerow(rowOk)
    return True
        
        
def exportStat(soluzione:str, exportFileName:str, NUM_DAY:int = 6) -> bool:
    '''Export delle statistiche sull'occupazione delle Aule'''
    db:dbAPI = dbAPI()
    # solo per accesso a costanti, strutture vuote
    AUX:AuxiliaryStruct = AuxiliaryStruct()
    
    listPianiAlloc:List[str] = list(db.get_pianiAllocazione())
    
    find = lambda listPianiAlloc: next((pianoAlloc for pianoAlloc in listPianiAlloc if pianoAlloc[0] == soluzione), None)
    if find(listPianiAlloc) == None:
        print("error: soluzione non presente nel db")
        return False
    
    with open(exportFileName, 'w') as f:
    
        for day in range(NUM_DAY):
            dayStr:str = getStringsFromDayHour(day,0)[0]        
            listSlotGiornata = db.get_slotInDayFromPianoAllocazione(soluzione, dayStr)
            f.write(dayStr + ":\n")
            
            for hour in range(AUX.NUM_SLOT_PER_DAY):
                
                nSlotAllocati:int = 0
                nSlotAllocati = len(list(filter(lambda slot: (getIdSlotFromString(dayStr, slot[9])[1] <= hour and
                                        getIdSlotFromString(dayStr, slot[9])[1]+int(slot[4]) > hour), listSlotGiornata
                                        )))
                f.write(getStringsFromDayHour(day,hour)[1] + ":\n")
                f.write("nSlot totali allocati: " + str(nSlotAllocati) + "\n")                
                
                # stat allocazione per capienza Aula
                for capienza in CapienzaLocale:
                    if capienza == CapienzaLocale.NonDisponibile:
                        continue
                    
                    nSlotAllocati:int = 0
                    nSlotAllocati = len(list(filter(lambda slot: (getIdSlotFromString(dayStr, slot[9])[1] <= hour and
                                        getIdSlotFromString(dayStr, slot[9])[1]+int(slot[4]) > hour and
                                        getStringFromCapienzaLocale(capienza) == slot[12]), listSlotGiornata
                                        )))
                    f.write("nSlot in Aula con capienza " + getStringFromCapienzaLocale(capienza) + ": " + str(nSlotAllocati) + "\n")
                    
                # stat allocazione per capienza Aula && prese elettriche
                for capienza in CapienzaLocale:
                    if capienza == CapienzaLocale.NonDisponibile:
                        continue
                    
                    nSlotAllocati:int = 0
                    nSlotAllocati = len(list(filter(lambda slot: (getIdSlotFromString(dayStr, slot[9])[1] <= hour and
                                        getIdSlotFromString(dayStr, slot[9])[1]+int(slot[4]) > hour and
                                        getStringFromCapienzaLocale(capienza) == slot[12] and
                                        getStringFromPreseElettriche(PreseElettriche.Si) == slot[14]), listSlotGiornata
                                        )))
                    f.write("nSlot in Aula con capienza " + getStringFromCapienzaLocale(capienza) + " e necessità prese elettriche: " + str(nSlotAllocati) + "\n")                      
                
                # stat allocazione per tipo di Aula
                for tipoLocale in TipoLocale:
                    if tipoLocale in [TipoLocale.Sconosciuto, TipoLocale.AulaMultimediale, TipoLocale.AulaAttrezzata]:
                        continue
                    
                    nSlotAllocati:int = 0
                    nSlotAllocati = len(list(filter(lambda slot: (getIdSlotFromString(dayStr, slot[9])[1] <= hour and
                                        getIdSlotFromString(dayStr, slot[9])[1]+int(slot[4]) > hour and
                                        getStringFromTipoLocale(tipoLocale) == slot[10]), listSlotGiornata
                                        )))
                    f.write("nSlot in locale di tipo " + getStringFromTipoLocale(tipoLocale) + ": " + str(nSlotAllocati) + "\n")                                          
                    
                    
        
        
exportCSV('test_relaxed3_opt_26323', 'orario_26323.csv')
exportStat('test_relaxed3_opt_26323', 'statistiche_26323.txt', 5)
exportMatriceCsv("test_relaxed3_opt_26323", "matrice_26323.csv")

exportCSV('test_relaxed3_opt_24395', 'orario_24395.csv')
exportStat('test_relaxed3_opt_24395', 'statistiche_24395.txt', 5)
exportMatriceCsv("test_relaxed3_opt_24395", "matrice_24395.csv")

exportCSV('test_relaxed3_opt_22552', 'orario_22552.csv')
exportStat('test_relaxed3_opt_22552', 'statistiche_22552.txt', 5)
exportMatriceCsv("test_relaxed3_opt_22552", "matrice_22552.csv")

exportCSV('test_relaxed3_opt_20397', 'orario_20397.csv')
exportStat('test_relaxed3_opt_20397', 'statistiche_20397.txt', 5)
exportMatriceCsv("test_relaxed3_opt_20397", "matrice_20397.csv")